\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{LHeC}[02/08/2010 V1.0 LHeC CDR]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions\relax
%\LoadClass[twoside]{report}
\LoadClass[twoside]{article}
\usepackage{url}
\usepackage{graphicx,epsfig,color}
\usepackage{wrapfig,rotating}
\usepackage{amssymb,amsmath,array}
\usepackage[latin1]{inputenc}
\usepackage{braket}
\usepackage{wasysym}

\usepackage{epstopdf}
% Requires enabling write18 on the machine being used
% which saves running epstopdf by hand

%% SWITCH THESE FOR FINAL SUBMISSION
%\usepackage[top=5.75pc, bottom=10.75pc, left=9pc,right=9pc]{geometry}
\usepackage{fullpage}


\newif\if@doi\@doifalse
\def\contribID#1{\gdef\@contribID{#1}}
\def\@contribID{\@latex@warning{Please provide the Contribution-ID}}
\def\confID#1{\@doitrue\gdef\@confID{#1}}
\def\doi{\@doitrue}

\def\desyproc#1{\gdef\@desyproc{#1}}                       
\gdef\@desyproc{\@latex@warning{No DESY-PROC number given}}

\def\acronym#1{\gdef\@acronym{#1}}                                  
\let\@acronym\@empty                                     


\def\@maketitle{%
  \newpage
  \parindent 0mm
  \null
  \vskip 2em%
  \let \footnote \thanks
    {\bfseries\LARGE \@title \par}%
    \vskip 1.5em%
    {\lineskip .5em%
        \@author
    }%
  \if@doi
     \par
     \vskip 1em
% =======  To the editor:  ==========================================
%   Please swap the comment of the following 2 lines. 
%   So the propper DOI appears on the document.
% -------------------------------------------------------------------
%     {\bfseries DOI:} {\texttt http://dx.doi.org/10.3204/\@desyproc/\@contribID}
     {\bfseries DOI:} {\texttt will be assigned}
  \fi
  \par
  \vskip 1.5em}

\if@titlepage
\else
  \renewenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \quote
      \fi}
      {\if@twocolumn\else\endquote\fi}
\fi

\def\ps@plain{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty\let\@evenhead\@empty
     \def\@evenfoot{\thepage\hfil\slshape \@acronym}%
     \def\@oddfoot{{\slshape \@acronym}\hfil\thepage}%
     }
\def\ps@empty{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty\let\@evenhead\@empty
     \def\@evenfoot{\hfil\slshape \@acronym}%
     \def\@oddfoot{{\slshape \@acronym}\hfil}%
}
\pagestyle{plain}
