#!/usr/bin/env python
# coding: utf-8
#
import numpy as np
#
def circleParams(r):
    '''
    Given the radius of a circle, this function returns its area and circumference.
    '''
    A = np.pi*r**2
    c = 2*np.pi*r
    return A, c
#
def rectangleParams(h, w):
    '''
    Given the height and width of a rectangle, this function returns its area and perimeter.
    '''
    A = h*w
    p = 2*(h + w)
    return A, p
#
def sphereParams(r):
    '''
    Given the radius of a sphere, this function returns its volume and its surface area.
    '''
    V = 4/3*np.pi*r**3
    A = 4*np.pi*r**2
    return V, A
#
def rectPrismParams(h, w, d):
    '''
    Given the height, width and depth of a rectangular prism, this function returns its volume, 
    surface area and total side length.
    '''
    V = h*w*d
    A = 2*(h*w + w*d + h*d)
    s = 4*(h + w + d)
    return V, A, s